#!/usr/bin/tclsh

if { $argc != 2 } {
    puts "Usage: \$argv0 \[ <binary_name> <object_name> \]"
    puts "  binary_name         - name of the target binary object"
    puts "  object_name         - name of the object containing the version symbols"
    puts ""
    exit 1
}

set exit_status 0
set binname [file tail [lindex $argv 0]]
set outfile [lindex $argv 1]

# Set the generated source file location and name
set cur_time [clock clicks]
set filename "$env(BUILD_DIR)/version_[pid]_$cur_time.c"

# Use GMT time
set env(TZ) GMT
set bld_date [clock format [clock seconds] -format %b_%d_%Y_%H:%M:%S]

# Make sure the generated source file doesn't exist
if [file isfile $filename] {
	if [ catch {[file delete -force $filename]} result ] {
	    puts "$argv0: Failed to delete file $filename"
	    exit 1
	}
}

# Build the source file to be compiled
# It containts only one line looking like:
# __declspec(dllexport) char    maintenance_date [] = "Jan_28_2013_10:23:12";
set maint_id [clock format [clock seconds] -format %b_%d_%Y_%H:%M:%S]
set win_exp "__declspec(dllexport)"

set id_source_handle [open $filename w]
puts $id_source_handle "$win_exp char    maintenance_date \[\] = \"$maint_id\"\;"
close $id_source_handle

puts "Building Version File"
# Compile the object
if { [catch { exec cl.exe /c /nologo /Zl /Fo$outfile /Tc$filename } result] } {
	set exit_status 1
	puts stderr $result
}

# Check compilation error status
if {$exit_status != 0} {
	puts "$argv0: Failed to build the version object file"
}
# Delete the source file and exit
file delete -force $filename

exit $exit_status
